/**********************************************************
 *(c) by Knobloch GmbH
 *       Weedgasse 14 
 *       D-55234 Erbes-Bdesheim                                    
 *
 *  File:           ftdemo1.c       Sampleprogram for Robo-Interface C-Compiler
 *
 *  Version:        0.01
 *
 *  Revision:
 *          0.01:   17.01.2006 
 *                  Start
 *
 *  This Sample switches Output O1 ON and OFF.
 *  The program stops, if Input I1 ist set to "1".
 *
 *  Then it jumps with a "return(x)" back to the Robo-If firmware.
 *  The firmware checks the value of "x" and the red "Error-Led"
 *  counts the x-value. With "0", the LED isnt blinking.
 *  You can use this function for testing your program.
 **********************************************************/
                  
#include    "TA_Firmware\TAF_00D.h"
#include    "TA_Firmware\TAF_00P.h"


UCHAR main(void)
{
    // New PWM for Outputs
    sTrans.MPWM_Main[0] = 8;    // PWM for Output O1

    // New Value for Outputs
    // Output PWM update (0x01=always, 0x02=once)
    // Base+0xE1: | 0  | 0  | 0  | 0  | 0  | 0  |ONCE|ALWA|
    sTrans.MPWM_Update = 0x01;  // Update PWM values every 10ms


    do
    {
        sTrans.M_Main = 0x01;       // switch Output O1 ON
        FtDelay(500);               // Wait 500ms
        sTrans.M_Main = 0x00;       // switch Output O1 OFF
        FtDelay(500);               // Wait 500ms
    }
    while ( (sTrans.E_Main & 0x01) == 0);    

    return (0);     // number of "Error - LED" blink times (0..5) after 
                    // program is finished
                    // With >5, the ERROR Led starts continously blinking. 
                    // You can stop this with pressing the Interface PROG Switch.
}
